/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.rendering;

import cpw.mods.fml.client.FMLClientHandler;
import jds.bibliocraft.BiblioRenderHelper;
import jds.bibliocraft.CommonProxy;
import jds.bibliocraft.Config;
import jds.bibliocraft.models.ModelWeaponCase;
import jds.bibliocraft.models.ModelWeaponCaseInner;
import jds.bibliocraft.models.OBJCase;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemWeaponCaseRenderer
implements IItemRenderer {
    private ModelWeaponCase caseModel;
    private ModelWeaponCaseInner innerModel;
    private OBJCase objModel = new OBJCase();
    private static boolean useTextureSheet;

    public ItemWeaponCaseRenderer() {
        this.caseModel = new ModelWeaponCase();
        this.innerModel = new ModelWeaponCaseInner();
        useTextureSheet = this.usesTextureSheet();
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        int metaTest = item.func_77960_j();
        String textureLoc = "none";
        NBTTagCompound tags = item.func_77978_p();
        if (tags != null && tags.func_74764_b("renderTexture")) {
            textureLoc = tags.func_74779_i("renderTexture");
        }
        switch (type) {
            case ENTITY: {
                this.renderWeaponCase(0.1f, 0.98f, 0.0f, metaTest, true, textureLoc);
                break;
            }
            case EQUIPPED: {
                this.renderWeaponCase(0.6f, 1.6f, 0.8f, metaTest, false, textureLoc);
                break;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.renderWeaponCase(0.6f, 1.6f, 0.8f, metaTest, false, textureLoc);
                break;
            }
            case INVENTORY: {
                this.renderWeaponCase(0.8f, 1.8f, 0.76f, metaTest, false, textureLoc);
                break;
            }
        }
    }

    private void renderWeaponCase(float i, float j, float k, int metaData, boolean entity, String texLoc) {
        float scale = 0.0625f;
        Tessellator tesselator = Tessellator.field_78398_a;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)i, (float)j, (float)k);
        if (entity) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        if (useTextureSheet && metaData != 6) {
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(this.getModelTexture(metaData));
            this.caseModel.renderShell();
            this.caseModel.lid.field_78808_h = 0.2f;
            this.caseModel.renderLid();
        } else {
            if (texLoc.contentEquals("none")) {
                FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(this.getVanillaWoodTexture(metaData));
            } else {
                FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(BiblioRenderHelper.getBlockResource(texLoc));
            }
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            this.objModel.renderBottomWood();
            this.objModel.renderLidWoodItem();
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(CommonProxy.GLASS);
            this.objModel.renderLidGlassItem();
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(CommonProxy.IRON);
            this.objModel.renderLidLatchItem();
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glPopMatrix();
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(CommonProxy.WHITEWOOL);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)i, (float)j, (float)k);
        if (entity) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        this.innerModel.renderInner();
        GL11.glPopMatrix();
    }

    public ResourceLocation getModelTexture(int metadata) {
        switch (metadata) {
            case 0: {
                return CommonProxy.WEAPONCASE0_PNG;
            }
            case 1: {
                return CommonProxy.WEAPONCASE1_PNG;
            }
            case 2: {
                return CommonProxy.WEAPONCASE2_PNG;
            }
            case 3: {
                return CommonProxy.WEAPONCASE3_PNG;
            }
            case 4: {
                return CommonProxy.WEAPONCASE4_PNG;
            }
            case 5: {
                return CommonProxy.WEAPONCASE5_PNG;
            }
        }
        return CommonProxy.WEAPONCASE0_PNG;
    }

    public ResourceLocation getVanillaWoodTexture(int meta) {
        switch (meta) {
            case 0: {
                return CommonProxy.PLANKSOAK;
            }
            case 1: {
                return CommonProxy.PLANKSSPRUCE;
            }
            case 2: {
                return CommonProxy.PLANKSBIRCH;
            }
            case 3: {
                return CommonProxy.PLANKSJUNGLE;
            }
            case 4: {
                return CommonProxy.PLANKSACACIA;
            }
            case 5: {
                return CommonProxy.PLANKSOLDOAK;
            }
            case 6: {
                return CommonProxy.FRAME_BLOCK;
            }
        }
        return CommonProxy.PLANKSOAK;
    }

    public boolean usesTextureSheet() {
        return Config.useTextureSheet;
    }
}

